<?php 
/*
Template Name: Home Page
*/
@include("header.php"); 
?>

	<section>
		<div class="grid-x">
			<div class="large-2 cell"></div>
			<div class="large-8 cell maincontent">
				<div class="grid-x headertext">
					<div class="large-12 cell">
						<?php if ( have_posts() ) : ?>
							<?php while ( have_posts() ) : the_post(); ?>
							  <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							    <div class="entry clear">
							       <?php the_content(); ?>
							    </div>
							    <!--end entry-->
							    </div><!--end post-->
							<?php endwhile; /* rewind or continue if all posts have been fetched */ ?>
							<?php else : ?>
						<?php endif; ?>
					</div>
				</div>
				<div class="grid-x">
			        <?php
			            $args = array (
			                 'sort_order'=>'ASC',
			                  'sort_column' => 'menu_order',
							  'parent'=> 9,
			                  'post-type'=>'pages'
			                                    );
			            $pages = get_pages($args);
			            foreach ($pages as $page) { 
			                    $div .= '<div class="large-3 cell">';
								$div .= '<div class="header"><a href="'.$page->guid.'">'.get_the_title($page->ID).'</a></div>';
			                    $div .= '<div class="thumbimage">'.get_the_post_thumbnail($page->ID).'</div>';
			                    if ($page->post_excerpt !='') {
			                        $div .= '<div class="collectionstext">'.$page->post_excerpt.'';
			                    } 
								$div .= '<a href="'.$page->guid.'"> more...</a>';
			                    $div .='</div><div class="clear"></div></div>';
			                 }
			            echo $div;
			        ?>
				</div>
			</div>
			<div class="large-2 cell"></div>
		</div>
	</section>

<?php @include("footer.php"); ?>
